var RESTCommand = require('restcommand').RESTCommand;
var RESTClient  = require('restclient').RESTClient;
var util        = require('util');
var iniReader   = require('inireader').IniReader;
var config      = new iniReader();

config.load(__dirname + '/../../server/config.ini');

try{
    config.load(__dirname + '/../../server/custom.ini');
}catch(e){
    //console.error(e.message);
}

var stack  = [];
var timers = [];
var stalker_api_url = config.param('stalker_api_url');

if (config.param('api_auth_login') && config.param('api_auth_password')){
    stalker_api_url = stalker_api_url.replace('://', '://'+config.param('api_auth_login')+':'+config.param('api_auth_password')+'@');
}

function RESTCommandRecorderTask(){

    this.get = function(request, callback){
        console.log('get', arguments);

        var identifiers = request.getIdentifiers();

        if (identifiers !== undefined){
            var f_stack = stack.filter(function(item){
                return identifiers.indexOf(item.id) >= 0;
            });
        }else{
            f_stack = stack;
        }

        return callback(stack.map(function(item){item.timer = undefined; return item}));
    };

    this.create = function(request, callback){
        console.log('create', arguments);
        
        var data = request.getData();

        if (!data.hasOwnProperty("id")){
            return callback(null, "Identifier missing");
        }

        if (!data.hasOwnProperty("time")){
            return callback(null, "Job time missing");
        }

        if (!data.hasOwnProperty("job")){
            return callback(null, "Job name missing");
        }

        var now = new Date().getTime()/1000;

        if (now > data.time){
            return callback(null, "Job time expired");
        }

        var self = this;
        var timeout = (data.time - now) * 1000;
        console.log('timeout', timeout);

        var timer = setTimeout(function(){
            new RESTClient(stalker_api_url)
                .resource("stream_recorder")
                .identifiers(data.id)
                .update({"action" : data.job})
                .on('end',
                    function(body, error){
                        console.log(body, error);
                        self._del_from_stack(data.id, data.job);

                });
            },
            timeout
        );

        callback(data);

        data.timer = timer;

        stack.push(data);
    };
    
    this.del  = function(request, callback){
        console.log('del', arguments);
        
        var identifiers = request.getIdentifiers();

        if (identifiers === undefined){
            return callback(null, "Identifiers are missing");
        }

        this._del_from_stack(identifiers);

        callback(true);
    };

    this.update = function(request, callback){
        console.log('update', arguments);

        var identifiers = request.getIdentifiers();

        if (identifiers === undefined){
            return callback(null, "Identifiers are missing");
        }

        var data = request.getData();

        if (!data.hasOwnProperty("time")){
            return callback(null, "Job time missing");
        }

        if (!data.hasOwnProperty("job")){
            return callback(null, "Job name missing");
        }

        identifiers = identifiers[0];

        data.id = identifiers;

        var now = new Date().getTime()/1000;

        if (data.job == 'stop'){

            this._del_from_stack(identifiers, data.job);

            var self = this;
            var timeout = (data.time - now) * 1000;

            if (timeout < 0) timeout = 0;

            console.log('timeout', timeout);

            var timer = setTimeout(function(){
                new RESTClient(stalker_api_url)
                    .resource("stream_recorder")
                    .identifiers(identifiers)
                    .update({"action" : data.job})
                    .on('end',
                        function(body, error){
                            console.log(body, error);
                            self._del_from_stack(data.id, data.job);

                    });
                },
                timeout
            );
            callback(data);

            data.timer = timer;

            stack.push(data);
        }else{
            callback(null, "Wrong job");
        }
    };

    this._del_from_stack = function(id, job){

        if(isNaN(parseInt(id, 10))){
            return false;
        }

        stack = stack.filter(function(item){

            if (item.id == id && (job  == undefined || item.job == job)){

                clearTimeout(item.timer);
                return false;
            }

            return true;
        });
    };
}

function sync(){
    new RESTClient(stalker_api_url)
        .resource("stream_recorder")
        .get()
        .on('end',
            function(body, error){
                console.log(body);
                if (error){
                    console.log(error);
                }
                stack = body.results || [];

                var now = new Date().getTime()/1000;

                var recorder_task = new RESTCommandRecorderTask();

                stack = stack.filter(function(item){

                    if ((item.job == 'stop' && item.time < now) || item.job == 'start' && item.time < now){

                        new RESTClient(stalker_api_url)
                            .resource("stream_recorder")
                            .identifiers(item.id)
                            .update({"action" : item.job})
                            .on('end',
                                function(body, error){
                                    console.log(body, error);

                            });
                        return false;
                    }else{

                        var self = this;
                        var timeout = (item.time - now) * 1000;

                        if (timeout < 0) timeout = 0;

                        console.log('id', item.id);
                        console.log('job', item.job);
                        console.log('timeout', timeout);

                        item.timer = setTimeout(function(){
                            new RESTClient(stalker_api_url)
                                .resource("stream_recorder")
                                .identifiers(item.id)
                                .update({"action" : item.job})
                                .on('end',
                                    function(body, error){
                                        console.log(body, error);
                                        recorder_task._del_from_stack(item.id, item.job);
                                });
                            },
                            timeout
                        );
                        
                        stack.push(item);
                    }
                    return true
                })
        });
}

util.inherits(RESTCommandRecorderTask, RESTCommand);

module.exports.RESTCommandRecorderTask = RESTCommandRecorderTask;
module.exports.sync = sync;